# Console

The easiest way of getting started with SCL is to use SCL console that is normally included in
Simantics-based products. You can open the console by pressing ALT-SHIFT-q and s or
from menu **Window/Show View/SCL Console**.

## Executing commands 

SCL console works by executing commands you write into the input box in the bottom of the view.
After the command has been written, it can be executed by pressing ENTER. If the command
contains syntax errors they are written to the console in red text and indication for the
error position.

Multi-line commands can be written by creating a new line with CTRL-ENTER. 
The command history can be browsed with CTRL-UP and CTRL-DOWN.
Also the standard keybindings CTRL-c (Copy), CTRL-v (Paste), CTRL-x (Cut), CTRL-a (Select all) work as expected
both in the input and output area of the console depending on which of them has a focus.
You can also write (or paste) multiple commands at the same time.

If the command you write into console results as an ordinary value, it is printed
to the console. Here are couple of examples you can try:

~~~
> 13
13
> 1+2
3
> sin 1
0.8414709848078965
> "Hello " + "world!"
Hello world!
> [1,3,5]
[1, 3, 5]
~~~

The console remembers the variables you declare, but they are forgotten when the
console (or the whole application) is closed.

~~~
> x = 35
> y = 40
> x + y
75
> x * y
1400
~~~

If you write a command that prints something as a side-effect, the prints are shown in the console:

~~~
> print "Hello" ; print "world!"
Hello
world!
~~~

The currently running command can be interrupted with **Interrupt current command** button
in the top right corner of the console.
All commands don't support interruption.
The output area of the console can be cleared with **Clear console** button.

## Importing modules

The rightmost button in the console opens a dialog for managing modules that are available
for the console. It shows currently imported modules and contains buttons for importing
modules from different sources. The imported modules are remembered even when the console
is closed if the import is marked persistent. 

The another way to import modules is run import command from the console, for example

    import "Simantics/DB"

The button with two arrows reloads the modules that are imported to the console. It
is useful if you develop your own module and want to test modified definitions.